/*
 * Decompiled with CFR 0.152.
 */
package net.coobird.thumbnailator.resizers;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.coobird.thumbnailator.resizers.Resizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResizer
implements Resizer {
    protected final Map<RenderingHints.Key, Object> RENDERING_HINTS = new HashMap<RenderingHints.Key, Object>();
    protected final Map<RenderingHints.Key, Object> UNMODIFIABLE_RENDERING_HINTS;
    protected static final RenderingHints.Key KEY_INTERPOLATION = RenderingHints.KEY_INTERPOLATION;

    protected AbstractResizer(Object object, Map<RenderingHints.Key, Object> map2) {
        this.RENDERING_HINTS.put(KEY_INTERPOLATION, object);
        if (map2.containsKey(KEY_INTERPOLATION) && !object.equals(map2.get(KEY_INTERPOLATION))) {
            throw new IllegalArgumentException("Cannot change the RenderingHints.KEY_INTERPOLATION value.");
        }
        this.RENDERING_HINTS.putAll(map2);
        this.UNMODIFIABLE_RENDERING_HINTS = Collections.unmodifiableMap(this.RENDERING_HINTS);
    }

    @Override
    public void resize(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.performChecks(bufferedImage, bufferedImage2);
        int n = bufferedImage2.getWidth();
        int n2 = bufferedImage2.getHeight();
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHints(this.RENDERING_HINTS);
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
    }

    protected void performChecks(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        if (bufferedImage == null || bufferedImage2 == null) {
            throw new NullPointerException("The source and/or destination image is null.");
        }
    }

    public Map<RenderingHints.Key, Object> getRenderingHints() {
        return this.UNMODIFIABLE_RENDERING_HINTS;
    }
}

